﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    <meta http-equiv="Content-Type" content="text/html; charset=unicode">
<title>Zestawienie księgowe</title>
    <script runat="server">
		
    void ZestawienieKsiegowe_OnLoad(Object sender, EventArgs args){
        OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
        ZestawienieKS z          = (ZestawienieKS)DataContext1.Get(typeof(ZestawienieKS));
        ZestawieniaKS.Params p      = (ZestawieniaKS.Params)DataContext1.Get(typeof(ZestawieniaKS.Params));
        string opis = "";
        if(z.Features.Definitions.Contains("Opis"))
					opis = z["Opis"].ToString();
				if(opis=="")
					ReportHeader1.Title = 
						string.Format(ReportHeader1.Title,z.Nazwa, o, p.Bufor ? "Tak" : "Nie");
         else
					ReportHeader1.Title = opis;
         

        
        DataContext1.Landscape = false;
        cc = ColumnsCreator.Init(z,o,p);
        cc.Landscape = DataContext1.Landscape;
        cc.Grid = Grid1;
    }
    
    ColumnsCreator cc = null;
    
    class ColumnsCreator {
      readonly ZestawienieKS.Wynik Wynik;
      public bool Landscape = false;
      
      public ColumnsCreator(ZestawienieKS.Wynik wynik){
        this.Wynik = wynik;
      }
      
      static public ColumnsCreator Init(ZestawienieKS zestawienie, OkresObrachunkowy okres, ZestawieniaKS.Params param){
        return new ColumnsCreator(zestawienie.ObliczZestawienie(okres,param));
      }
      
      static int szeroki = 8;
      static int waski   = 4;
      
      void initColumns(){
        int iloscKolumnZest = Wynik.Zestawienie.Kolumny.Count;
        int maxIloscKolumn = (Landscape)? szeroki : waski;
        if(iloscKolumnZest>0)
          grid.RowsInRow = (int)Math.Ceiling( (double)iloscKolumnZest / maxIloscKolumn);
        int iloscKolumn = (int)Math.Ceiling((double)iloscKolumnZest / grid.RowsInRow);
        int iloscKomorek = iloscKolumn * grid.RowsInRow;
				
        GridColumn col = null;
        col = new GridColumn();
        col.Caption = "Numer";
        col.Width = 12;
        col.RowSpan = grid.RowsInRow;
        grid.Columns.Add(col);
        
        
        col = new GridColumn();
        col.Caption = "Opis";
        col.RowSpan = grid.RowsInRow;
        grid.Columns.Add(col);
        
        foreach(KolumnaZestKS kol in Wynik.Zestawienie.Kolumny){
          col = new GridColumn();
          col.Caption = kol.Nazwa;
          col.Width = 16;
          col.Format = "{0:n}";
          col.Align = HorizontalAlign.Right;
          grid.Columns.Add(col);
          iloscKomorek--;
        }

				while(iloscKomorek>0){
          col = new GridColumn();
          col.Caption = "";
          grid.Columns.Add(col);
          iloscKomorek--;				
				}
        
        grid.DataSource = Wynik.Pozycje;
      }
      
      public Grid Grid{
        get{
          return grid;  
        }
        set{
          detachGrid();
          grid = value;
          attachGrid();
          initColumns();
        }
      }
      
      void attachGrid(){
        if(grid==null)
          return;
        grid.BeforeRow += new RowEventHandler(OnBeforeRow);
      }
      void detachGrid(){
        if(grid==null)
          return;
        grid.BeforeRow -= new RowEventHandler(OnBeforeRow);
      }
      
      Grid grid = null;
      
      void OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        ZestawienieKS.Pozycja poz = (ZestawienieKS.Pozycja)args.Row; 
        PozycjaZestKS p = (PozycjaZestKS)KsiegaModule.GetInstance(poz.Wynik.Zestawienie).PozycjeZestKS.WgZestawienie[poz.Wynik.Zestawienie,poz.Symbol].GetPrev();
        string format = "";
        object obj = null;
        if(p.Features.Definitions.Contains("Format"))
					obj = p["Format"];
					
        if(obj!=null)
					format = obj.ToString();
				if(format=="")
					format = "{0}";
					
        grid.Columns[0].EditValue = string.Format(format,poz.Numer);
        grid.Columns[1].EditValue = string.Format(format,poz.Opis);
        
				format = format.Replace("{0}","{0:n}");

        for(int i=0; i<poz.Komorki.Count ; i++)
          grid.Columns[i+2].EditValue = string.Format(format,poz[i].Wartosc);
      }
    }
    </script>
    
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
  </HEAD>
  <body>
    <form id="ZestawienieKsiegowe" method="post" runat="server" onload="ZestawienieKsiegowe_OnLoad">
      <ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Ksiega.ZestawienieKS, Soneta.Ksiega"></ea:datacontext>
      <cc1:ReportHeader id="ReportHeader1" title="{0} | Okres obrachunkowy: {1},  Uwzględniać bufor: {2}" runat="server"></cc1:ReportHeader><BR>
      <ea:grid id="Grid1" runat="server" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True"></ea:grid>
      <cc1:ReportFooter id="ReportFooter1" runat="server">
        <Subtitles>
          <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
        </Subtitles>
      </cc1:ReportFooter>
    </form>
  </body>
</HTML>

